/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.OutputReport;
import probabilisticcellularautomata.Rule;
import probabilisticcellularautomata.Tools;

public class Configuration {
    private int status;
    private int size;
    private double density;
    private double degreeOfRandomness;
    private int[] cells;

    public Configuration(int size, double density, double degreeOfRandomness, int[] cells) {
        this.status = -1;
        this.size = size;
        this.density = density;
        this.degreeOfRandomness = degreeOfRandomness;
        this.cells = cells;
    }

    public Configuration(int[] cells) {
        this.status = 0;
        this.cells = cells;
        this.size = this.cells.length;
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            if (this.cells[i] != 1) continue;
            sum += 1.0;
        }
        this.density = sum / (double)this.size;
    }

    public void initialize() {
        if (this.status == -1) {
            if (this.size == -1) {
                this.size = Tools.uniformRandomVariable(1, 99) * 2 + 1;
            }
            if (this.cells[0] == -1) {
                this.cells = new int[this.size];
                if (this.density != -3.0) {
                    if (this.density == -1.0) {
                        this.density = Math.random();
                    }
                    if (this.degreeOfRandomness == -1.0) {
                        this.degreeOfRandomness = Math.random();
                    }
                    this.cells = Configuration.mixUp(this.size, this.density, this.degreeOfRandomness);
                } else {
                    this.cells = Configuration.randomConfiguration(this.cells.length);
                }
            }
            this.degreeOfRandomness = (double)Math.round(this.degreeOfRandomness * (double)this.size) / (double)this.size;
            double sum = 0.0;
            for (int i = 0; i < this.size; ++i) {
                if (this.cells[i] != 1) continue;
                sum += 1.0;
            }
            this.density = sum / (double)this.size;
            this.status = 0;
        }
    }

    public int getsize() {
        return this.size;
    }

    public double getDensity() {
        return this.density;
    }

    public int[] getCells() {
        return this.cells;
    }

    public double getDegreeOfRandomness() {
        return this.degreeOfRandomness;
    }

    public int getSize() {
        return this.size;
    }

    public int getStatus() {
        return this.status;
    }

    public void setDegreeOfRandomness(double degreeOfRandomness) {
        this.degreeOfRandomness = degreeOfRandomness;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setCells(int[] cells) {
        this.cells = cells;
    }

    public void setDensity(double density) {
        this.density = density;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void resetCells() {
        this.cells = null;
    }

    public int[] applyRule(Rule rule) {
        int[] newCells = new int[this.size];
        int[] ruleInstancesApplied = new int[this.size];
        int randomVariable = rule.getRandomVariableLookupArray()[(int)(100.0 * Math.random())];
        for (int i = 0; i < this.size; ++i) {
            int sum = 0;
            int exp = 0;
            for (int j = i + 1; j >= i - 1; --j) {
                int position = 0 <= j && j < this.size ? j : (j < 0 ? this.size + j : j - this.size);
                if (this.cells[position] == 1) {
                    sum += (int)Math.pow(2.0, exp);
                }
                ++exp;
            }
            newCells[i] = rule.getRuleBits()[sum][randomVariable];
            ruleInstancesApplied[i] = randomVariable;
            if (rule.getApplyRuleInstancesUniformly() != 0) continue;
            randomVariable = rule.getRandomVariableLookupArray()[(int)(100.0 * Math.random())];
        }
        this.cells = newCells;
        double sum = 0.0;
        for (int i = 0; i < this.size; ++i) {
            if (this.cells[i] != 1) continue;
            sum += 1.0;
        }
        this.density = sum / (double)this.size;
        return ruleInstancesApplied;
    }

    public static int[] mixUp(int size, double density, double degreeOfRandomness) {
        int i;
        int[] result = new int[size];
        int[] perm1 = Configuration.permutation(size);
        int[] perm2 = Configuration.permutation(size);
        int ones = (int)Math.round(density * (double)size);
        int zeros = size - ones;
        int cellsToMixUp = (int)Math.round(degreeOfRandomness * (double)size);
        for (i = 0; i < size - zeros; ++i) {
            result[i] = 1;
        }
        for (i = 0; i < cellsToMixUp; ++i) {
            Configuration.swap(result, perm1[i], perm2[i]);
        }
        return result;
    }

    private static int[] permutation(int a) {
        int[] result = new int[a];
        boolean[] check = new boolean[a];
        for (int i = a - 1; i >= 0; --i) {
            int rv = Tools.uniformRandomVariable(0, i);
            for (int j = 0; j <= rv; ++j) {
                if (!check[j]) continue;
                ++rv;
            }
            result[rv] = a - 1 - i;
            check[rv] = true;
        }
        return result;
    }

    private static void swap(int[] a, int index1, int index2) {
        int temp = a[index1];
        a[index1] = a[index2];
        a[index2] = temp;
    }

    public static int[] randomConfiguration(int s) {
        int[] result = new int[s];
        for (int i = 0; i < s; ++i) {
            result[i] = Tools.bernoulliRandomVariable(0.5);
        }
        return result;
    }

    public Configuration clone() {
        if (this.status == -1) {
            return new Configuration(this.size, this.density, this.degreeOfRandomness, (int[])this.cells.clone());
        }
        System.out.println("Configuration could not be cloned properly because it was already initialized!");
        return null;
    }

    public void print(OutputReport output) {
        output.addLine("\u25ba  CONFIGURATION:");
        output.addLine("> Lattice size:");
        if (this.size == -1) {
            output.addLine("random");
        } else if (this.size == -2) {
            output.addLine("variable");
        } else {
            output.addLine(this.size + "");
        }
        output.addLine("> Initial density:");
        if (this.density == -1.0) {
            output.addLine("random");
        } else if (this.density == -2.0) {
            output.addLine("variable");
        } else if (this.density == -3.0) {
            output.addLine("-");
        } else {
            output.addLine(this.density + "");
        }
        output.addLine("> Fraction of randomly dist. cells:");
        if (this.degreeOfRandomness == -1.0) {
            output.addLine("random");
        } else if (this.degreeOfRandomness == -2.0) {
            output.addLine("variable");
        } else if (this.degreeOfRandomness == -3.0) {
            output.addLine("-");
        } else {
            output.addLine(this.degreeOfRandomness + "");
        }
        output.addLine("> Initial configuration:");
        if (this.cells[0] == -1) {
            output.addLine("random");
        } else {
            output.addLine("$" + Tools.toCellsString(this.cells));
        }
    }
}

