/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.Configuration;
import probabilisticcellularautomata.ExperimentLog;
import probabilisticcellularautomata.OutputExperiment;
import probabilisticcellularautomata.OutputProgressBar;
import probabilisticcellularautomata.OutputReport;
import probabilisticcellularautomata.Problem;
import probabilisticcellularautomata.Rule;

public class Experiment {
    private ExperimentLog firstLogEntry;
    private ExperimentLog lastLogEntry;
    private Rule rule;
    private Problem problem;
    private int status;
    private int duration;
    private int[][] experimentLog;

    public Experiment(Configuration configuration, Rule rule, Problem problem) {
        this.lastLogEntry = this.firstLogEntry = new ExperimentLog(null, configuration, null, 0);
        this.rule = rule;
        this.problem = problem;
        this.status = 0;
        this.duration = 0;
        this.experimentLog = null;
    }

    private void initialize() {
        this.firstLogEntry.getConfiguration().initialize();
        this.problem.initialize();
        this.rule.initialize();
        this.status = 0;
    }

    public int getDuration() {
        return this.duration;
    }

    public ExperimentLog getFirstLogEntry() {
        return this.firstLogEntry;
    }

    public ExperimentLog getLastLogEntry() {
        return this.lastLogEntry;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public Rule getRule() {
        return this.rule;
    }

    public int getStatus() {
        return this.status;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setFirstLogEntry(ExperimentLog firstLogEntry) {
        this.firstLogEntry = firstLogEntry;
    }

    public void setLastLogEntry(ExperimentLog lastLogEntry) {
        this.lastLogEntry = lastLogEntry;
    }

    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void run(boolean showProgress, int verbose, int index) {
        OutputProgressBar progress = null;
        if (this.status == 0) {
            this.initialize();
            if (verbose > 0) {
                ExperimentLog[] startPages;
                if (showProgress) {
                    progress = this.problem.getMaximumRuntime() == -3 ? new OutputProgressBar(10000) : new OutputProgressBar(this.problem.getMaximumRuntime());
                    progress.draw();
                }
                int i = 0;
                while (this.problem.finished(this.firstLogEntry.getConfiguration(), this.lastLogEntry.getConfiguration(), i + 1) == 0) {
                    if (showProgress && i % 100 == 0) {
                        progress.setProgress(i);
                    }
                    this.lastLogEntry.insert(new Configuration(this.lastLogEntry.getConfiguration().getCells()), i + 1);
                    this.lastLogEntry = this.lastLogEntry.next;
                    int[] ruleInstancesApplied = this.lastLogEntry.getConfiguration().applyRule(this.rule);
                    this.lastLogEntry.setLastRuleInstance(ruleInstancesApplied);
                    ++i;
                }
                if (showProgress) {
                    progress.setProgress(this.problem.getMaximumRuntime());
                }
                this.duration = i;
                this.status = this.problem.finished(this.firstLogEntry.getConfiguration(), this.lastLogEntry.getConfiguration(), this.duration + 1);
                ExperimentLog e = this.firstLogEntry;
                int k = 0;
                if (this.duration > 0 && this.duration <= 10000) {
                    startPages = new ExperimentLog[(this.duration - 1) / 1000 + 1];
                    while (e.next != null) {
                        if (k % 1000 == 0) {
                            startPages[k / 1000] = e;
                        }
                        e = e.next;
                        ++k;
                    }
                } else {
                    startPages = new ExperimentLog[]{};
                }
                for (int j = startPages.length - 1; j >= 0; --j) {
                    new OutputExperiment(startPages[j], this.duration - 1000 * j, this.problem.getProblemType(), this.problem.getMaximumRuntime() - 1000 * j, this.status, index, j).draw();
                }
                this.print(new OutputReport(0, index));
                if (showProgress) {
                    progress.close();
                }
                this.firstLogEntry.printInConsole(verbose - 1);
            } else {
                int i = 1;
                this.firstLogEntry.insert(new Configuration(this.lastLogEntry.getConfiguration().getCells()), i);
                this.lastLogEntry = this.firstLogEntry.next;
                while (this.problem.finished(this.firstLogEntry.getConfiguration(), this.lastLogEntry.getConfiguration(), i) == 0) {
                    this.lastLogEntry.getConfiguration().applyRule(this.rule);
                    this.lastLogEntry.setIndex(i);
                    ++i;
                }
                int[] temp = new int[]{};
                this.lastLogEntry.setLastRuleInstance(temp);
                this.duration = i - 1;
                this.status = this.problem.finished(this.firstLogEntry.getConfiguration(), this.lastLogEntry.getConfiguration(), this.duration + 1);
            }
        }
    }

    public Experiment clone() {
        if (this.status == 0) {
            return new Experiment(this.firstLogEntry.getConfiguration().clone(), this.rule.clone(), this.problem.clone());
        }
        System.out.println("Experiment could not be cloned properly because it was already initialized!");
        return null;
    }

    public void print(OutputReport output) {
        if (this.status != 0) {
            output.addLine("\u25ba  EXPERIMENT:");
            output.addLine("> Result:");
        }
        if (this.status == 1) {
            output.addLine("Correctly solved");
        } else if (this.status == 2) {
            output.addLine("Incorrectly solved");
        } else if (this.status == 3) {
            output.addLine("Not terminated");
        }
        if (this.status != 0) {
            output.addLine("> Time units:");
            output.addLine(this.duration + "");
        }
        this.problem.print(output);
        this.firstLogEntry.getConfiguration().print(output);
        this.rule.print(output);
        output.draw();
    }
}

