/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.Configuration;
import probabilisticcellularautomata.Tools;

public class ExperimentLog {
    public ExperimentLog next;
    private Configuration configuration;
    private int[] lastRuleInstance;
    private int index;

    public ExperimentLog(ExperimentLog next, Configuration configuration, int[] lastRuleInstance, int index) {
        this.next = next;
        this.configuration = configuration;
        this.lastRuleInstance = lastRuleInstance;
        this.index = index;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int[] getLastRuleInstance() {
        return this.lastRuleInstance;
    }

    public ExperimentLog getNext() {
        return this.next;
    }

    public int getIndex() {
        return this.index;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setLastRuleInstance(int[] lastRuleInstance) {
        this.lastRuleInstance = lastRuleInstance;
    }

    public void setNext(ExperimentLog next) {
        this.next = next;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void insert(Configuration configuration, int index) {
        this.next = new ExperimentLog(null, configuration, null, index);
    }

    public void printInConsole(int verbose) {
        if (verbose > 0) {
            System.out.print("\u25ba  EXPERIMENT DETAILS\n\n");
            ExperimentLog i = this;
            System.out.print("   > Time steps, Configurations, densities and rule instances:\n");
            System.out.print("   > " + Tools.formatInteger(i.index, 10) + "   " + Tools.toCellsString(i.getConfiguration().getCells()) + "   " + Tools.formatDouble(i.getConfiguration().getDensity(), 0, 3) + "\n");
            while (i.next != null) {
                i = i.next;
                System.out.print("   >              " + Tools.toCellsString(i.getLastRuleInstance()) + "\n");
                System.out.print("   > " + Tools.formatInteger(i.index, 10) + "   " + Tools.toCellsString(i.getConfiguration().getCells()) + "   " + Tools.formatDouble(i.getConfiguration().getDensity(), 0, 3) + "\n");
            }
            System.out.print("\n");
        }
    }
}

