/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.OutputGraph;
import probabilisticcellularautomata.OutputProgressBar;
import probabilisticcellularautomata.OutputReport;
import probabilisticcellularautomata.Statistic;
import probabilisticcellularautomata.Tools;

public class Graph {
    private Statistic test;
    private int variable;
    private int numberOfTests;
    private int status;
    private double[] xValues;
    private double[] yValuesAverageTime;
    private double[] yValuesCorrect;
    private double[] yValuesIncorrect;
    private double[] yValuesNotTerminated;
    private double lowerBound;
    private double upperBound;

    public Graph(Statistic test, int numberOfTests, int variable, double lowerBound, double upperBound) {
        this.test = test;
        this.variable = variable;
        this.numberOfTests = numberOfTests;
        this.status = 0;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        int numberOfTestsInRange = (int)Math.round((upperBound - lowerBound) * (double)numberOfTests);
        if (numberOfTests != -3) {
            this.xValues = new double[numberOfTestsInRange];
            this.yValuesCorrect = new double[numberOfTestsInRange];
            this.yValuesIncorrect = new double[numberOfTestsInRange];
            this.yValuesNotTerminated = new double[numberOfTestsInRange];
            this.yValuesAverageTime = new double[numberOfTestsInRange];
        } else {
            this.xValues = null;
            this.yValuesCorrect = null;
            this.yValuesIncorrect = null;
            this.yValuesNotTerminated = null;
            this.yValuesAverageTime = null;
        }
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public int getStatus() {
        return this.status;
    }

    public Statistic getTest() {
        return this.test;
    }

    public int getVariable() {
        return this.variable;
    }

    public double[] getxValues() {
        return this.xValues;
    }

    public double[] getyValuesAverageTime() {
        return this.yValuesAverageTime;
    }

    public double[] getyValuesCorrect() {
        return this.yValuesCorrect;
    }

    public double[] getyValuesIncorrect() {
        return this.yValuesIncorrect;
    }

    public double[] getyValuesNotTerminated() {
        return this.yValuesNotTerminated;
    }

    public void setNumberOfTests(int numberOfTests) {
        this.numberOfTests = numberOfTests;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTest(Statistic test) {
        this.test = test;
    }

    public void setVariable(int variable) {
        this.variable = variable;
    }

    public void setxValues(double[] xValues) {
        this.xValues = xValues;
    }

    public void setyValuesAverageTime(double[] yValuesAverageTime) {
        this.yValuesAverageTime = yValuesAverageTime;
    }

    public void setyValuesCorrect(double[] yValuesCorrect) {
        this.yValuesCorrect = yValuesCorrect;
    }

    public void setyValuesIncorrect(double[] yValuesIncorrect) {
        this.yValuesIncorrect = yValuesIncorrect;
    }

    public void setyValuesNotTerminated(double[] yValuesNotTerminated) {
        this.yValuesNotTerminated = yValuesNotTerminated;
    }

    public void run(boolean showProgress, int verbose, int index) {
        double endX;
        double startX;
        double deltaX;
        this.status = 1;
        OutputProgressBar progress = null;
        if (showProgress) {
            progress = new OutputProgressBar((int)((this.upperBound - this.lowerBound) * (double)this.numberOfTests));
            progress.draw();
        }
        if (this.variable == 2 || this.variable == 7 || this.variable == 8 || this.variable == 11) {
            deltaX = this.numberOfTests == 24 ? 0.04 : (this.numberOfTests == 49 ? 0.02 : 0.01);
            startX = this.lowerBound + deltaX;
            endX = this.upperBound;
        } else if (this.variable == 5) {
            deltaX = this.numberOfTests == 24 ? 40.0 : (this.numberOfTests == 49 ? 20.0 : 10.0);
            startX = 1000.0 * this.lowerBound + deltaX;
            endX = 1000.0 * this.upperBound;
        } else if (this.variable == 6) {
            deltaX = this.numberOfTests == 24 ? 8.0 : (this.numberOfTests == 49 ? 4.0 : 2.0);
            startX = 200.0 * this.lowerBound + deltaX + 1.0;
            endX = 200.0 * this.upperBound;
        } else {
            System.out.print("Something got wrong: variable number was not correct.");
            this.status = 2;
            return;
        }
        int i = 0;
        for (double valueX = startX; valueX < endX; valueX += deltaX) {
            Statistic temp = this.test.clone();
            if (this.variable == 2) {
                temp.getExperiment().getProblem().setDensityThreshold(valueX);
            } else if (this.variable == 5) {
                temp.getExperiment().getProblem().setMaxTime((int)valueX);
            } else if (this.variable == 6) {
                temp.getExperiment().getFirstLogEntry().getConfiguration().setSize((int)valueX);
            } else if (this.variable == 7) {
                temp.getExperiment().getFirstLogEntry().getConfiguration().setDensity(valueX);
            } else if (this.variable == 8) {
                temp.getExperiment().getFirstLogEntry().getConfiguration().setDegreeOfRandomness(valueX);
            } else if (this.variable == 11) {
                temp.getExperiment().getRule().setBinomialDistributionProbability(valueX);
            } else {
                System.out.print("Something got wrong: variable number was not correct.");
                this.status = 2;
                return;
            }
            temp.run(false, verbose - 1, i + 1);
            this.xValues[i] = valueX;
            this.yValuesCorrect[i] = temp.getCorrect();
            this.yValuesIncorrect[i] = temp.getIncorrect();
            this.yValuesNotTerminated[i] = temp.getNotTerminated();
            this.yValuesAverageTime[i] = temp.getAverageRuntime();
            ++i;
            if (!showProgress) continue;
            progress.setProgress(i);
        }
        this.status = 2;
        if (showProgress) {
            progress.close();
        }
        if (verbose > 0) {
            new OutputGraph(this.xValues, this.yValuesCorrect, this.yValuesIncorrect, this.yValuesNotTerminated, this.yValuesAverageTime, 0, this.variable, index).draw();
            new OutputGraph(this.xValues, this.yValuesCorrect, this.yValuesIncorrect, this.yValuesNotTerminated, this.yValuesAverageTime, 1, this.variable, index).draw();
            this.print(new OutputReport(2, index));
        }
    }

    public void print(OutputReport output) {
        output.addLine("\u25ba  GRAPH:");
        output.addLine("> Number of Statistics:");
        output.addLine(this.numberOfTests + "");
        output.addLine("> Variable:");
        if (this.variable == 2) {
            output.addLine("Density Threshold");
        } else if (this.variable == 5) {
            output.addLine("Maximum Runtime");
        } else if (this.variable == 6) {
            output.addLine("Lattice Size");
        } else if (this.variable == 7) {
            output.addLine("Initial density");
        } else if (this.variable == 8) {
            output.addLine("Fraction of randomly distributed cells");
        } else {
            output.addLine("Success probability");
        }
        System.out.print("\u25ba  GRAPH DETAILS\n\n");
        System.out.print("   > x values:             " + Tools.toArrayString(this.xValues) + "\n");
        System.out.print("   > Correct:     " + Tools.toArrayString(this.yValuesCorrect) + "\n");
        System.out.print("   > Incorrect:   " + Tools.toArrayString(this.yValuesIncorrect) + "\n");
        System.out.print("   > Not terminated:       " + Tools.toArrayString(this.yValuesNotTerminated) + "\n");
        System.out.print("   > Average running time: " + Tools.toArrayString(this.yValuesAverageTime) + "\n");
        System.out.print("\n");
        this.test.print(output);
    }
}

