/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.Configuration;
import probabilisticcellularautomata.Experiment;
import probabilisticcellularautomata.Graph;
import probabilisticcellularautomata.Input;
import probabilisticcellularautomata.Problem;
import probabilisticcellularautomata.Rule;
import probabilisticcellularautomata.Statistic;
import probabilisticcellularautomata.Tools;

public class Main {
    public static void main(String[] args) {
        int acc1;
        int acc0;
        int iters;
        boolean justTest = false;
        if (justTest) {
            iters = 1000000;
            int p = 15;
            int[] a = new int[]{1 - p, p};
            acc0 = 0;
            acc1 = 0;
            for (int i = 0; i < iters; ++i) {
                if (Tools.userDefinedRandomVariable(a) == 0) {
                    ++acc0;
                    continue;
                }
                ++acc1;
            }
        } else {
            Input.start();
            while (true) {
                if (!Input.isReady()) continue;
                System.out.println("Starting...\n");
                Input.setReady(false);
                Problem problem = new Problem(Input.getDensityThreshold(), Input.getTemplateCells(), Input.getMaximumRunningTime());
                Configuration configuration = new Configuration(Input.getLatticeSize(), Input.getDensity(), Input.getDegreeOfChaos(), Input.getCells());
                Rule rule = new Rule(Input.getNumberOfRuleInstances(), Input.getBinomialDistributionProbability(), Input.getApplyRuleInstanceUniformly(), Input.getRuleInstanceNumbers(), Input.getRuleInstanceProbabilities());
                Experiment experiment = new Experiment(configuration, rule, problem);
                Statistic test = new Statistic(experiment, Input.getNumberOfExperiments());
                Graph statistic = new Graph(test, Input.getNumberOfTests(), Input.getVaryingParameter(), Input.getLowerBound(), Input.getUpperBound());
                if (Input.getTask() == 0) {
                    experiment.run(true, Input.getVerbose(), 0);
                } else if (Input.getTask() == 1) {
                    test.run(true, Input.getVerbose(), 0);
                } else {
                    statistic.run(true, Input.getVerbose(), 0);
                }
                System.out.println("Finished.\n");
            }
        }
        System.out.println((double)acc0 / (double)iters);
        System.out.println((double)acc1 / (double)iters);
    }
}

