/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import javax.swing.JFrame;
import javax.swing.JPanel;
import probabilisticcellularautomata.ExperimentLog;

public class OutputExperiment
extends JPanel {
    private ExperimentLog experimentLog;
    private int duration;
    private int latticeSize;
    private int problemType;
    private int maximumRuntime;
    private int experimentStatus;
    private boolean overrunFrame;
    private int page;
    private int index;

    public OutputExperiment(ExperimentLog experimentLog, int duration, int problemType, int maximumRuntime, int experimentStatus, int index, int page) {
        this.experimentLog = experimentLog;
        if (duration > 1000) {
            this.duration = 1000;
            this.overrunFrame = true;
        } else {
            this.duration = duration;
            this.overrunFrame = false;
        }
        this.latticeSize = experimentLog.getConfiguration().getSize();
        this.problemType = problemType;
        this.maximumRuntime = maximumRuntime < 0 || maximumRuntime > 1000 ? 1000 : maximumRuntime;
        this.experimentStatus = experimentStatus;
        this.index = index;
        this.page = page;
    }

    public int[][] experimentLogToArray() {
        int[][] result;
        block11: {
            int i;
            ExperimentLog temp;
            block10: {
                result = this.problemType == 0 || this.problemType == 1 ? new int[this.maximumRuntime][this.latticeSize] : new int[this.duration][this.latticeSize];
                temp = this.experimentLog;
                for (i = 1; i <= this.duration; ++i) {
                    temp = temp.next;
                    result[i - 1] = temp.getConfiguration().getCells();
                }
                if (this.problemType != 0) break block10;
                for (i = this.duration + 1; i <= this.maximumRuntime; ++i) {
                    if (temp.getConfiguration().getDensity() == 0.0) {
                        result[i - 1] = new int[this.latticeSize];
                        continue;
                    }
                    result[i - 1] = new int[this.latticeSize];
                    for (int j = 0; j < this.latticeSize; ++j) {
                        result[i - 1][j] = 1;
                    }
                }
                break block11;
            }
            if (this.problemType != 1) break block11;
            for (i = this.duration + 1; i <= this.maximumRuntime; ++i) {
                int j;
                if (temp.getConfiguration().getDensity() == 0.0) {
                    if ((i - this.duration - 1) % 2 == 0) {
                        result[i - 1] = new int[this.latticeSize];
                        for (j = 0; j < this.latticeSize; ++j) {
                            result[i - 1][j] = 1;
                        }
                        continue;
                    }
                    result[i - 1] = new int[this.latticeSize];
                    continue;
                }
                if ((i - this.duration - 1) % 2 == 1) {
                    result[i - 1] = new int[this.latticeSize];
                    for (j = 0; j < this.latticeSize; ++j) {
                        result[i - 1][j] = 1;
                    }
                    continue;
                }
                result[i - 1] = new int[this.latticeSize];
            }
        }
        return result;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int[][] cells = this.experimentLogToArray();
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        int labelWidth = 50;
        int labelHeight = 10;
        int separation = 5;
        int size = cells[0].length;
        int marginVertical = 50;
        int marginHorizontal = 50;
        int boxWidth = windowWidth - 2 * marginHorizontal;
        int boxHeight = windowHeight - 2 * marginVertical - labelHeight;
        int innerMarginTop = (windowHeight - 500) / 2;
        int innerMarginLeft = (windowWidth - 2 * (labelWidth + size) - separation) / 2 - 10;
        g2.setPaint(new Color(0, 0, 0));
        OutputExperiment.drawThickRectangle(g2, marginHorizontal, marginVertical, boxWidth, boxHeight);
        g2.setPaint(new Color(255, 255, 255));
        g2.fillRect(marginHorizontal + 2, marginVertical + 2, boxWidth - 4, boxHeight - 4);
        g2.setPaint(new Color(127, 127, 127));
        OutputExperiment.drawThickRectangle(g2, innerMarginLeft + labelWidth - 1, innerMarginTop - 1, size + 3, 503);
        OutputExperiment.drawThickRectangle(g2, innerMarginLeft + 2 * labelWidth + separation + size - 1, innerMarginTop - 1, size + 3, 503);
        g2.setPaint(new Color(238, 238, 238));
        g2.fillRect(innerMarginLeft + labelWidth + 1, innerMarginTop + 1, size, 500);
        g2.fillRect(innerMarginLeft + 2 * labelWidth + separation + size + 1, innerMarginTop + 1, size, 500);
        g2.setPaint(new Color(0, 0, 0));
        for (int i = 1; i <= 11; ++i) {
            this.writeInteger(g2, 1000 * this.page + 50 * (i - 1), innerMarginLeft + labelWidth / 2, innerMarginTop + 50 * (i - 1));
            this.writeInteger(g2, 1000 * this.page + 50 * (i - 1) + 500, innerMarginLeft + 3 * labelWidth / 2 + separation + size, innerMarginTop + 50 * (i - 1));
        }
        for (int j = 0; j < cells.length; ++j) {
            for (int i = 0; i < size; ++i) {
                if (cells[j][i] == 0) {
                    g2.setPaint(new Color(255, 255, 255));
                } else {
                    g2.setPaint(new Color(0, 0, 0));
                }
                if (j < 500) {
                    g2.drawLine(innerMarginLeft + labelWidth + 1 + i, innerMarginTop + 1 + j, innerMarginLeft + labelWidth + 1 + i, innerMarginTop + 1 + j);
                    continue;
                }
                g2.drawLine(innerMarginLeft + 2 * labelWidth + size + separation + 1 + i, innerMarginTop - 499 + j, innerMarginLeft + 2 * labelWidth + size + separation + 1 + i, innerMarginTop - 499 + j);
            }
        }
    }

    private static void drawThickRectangle(Graphics2D g2, int x, int y, int width, int height) {
        g2.drawRect(x - 1, y - 1, width + 2, height + 2);
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
    }

    private void writeText(Graphics2D g2, String text, float x, float y) {
        Font font = g2.getFont();
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        float height = (float)font.getStringBounds(text, fontRenderContext).getHeight();
        float width = (float)font.getStringBounds(text, fontRenderContext).getWidth();
        g2.drawString(text, x - width / 2.0f, y + height / 3.0f);
    }

    private void writeInteger(Graphics2D g2, int i, float x, float y) {
        this.writeText(g2, new Integer(i).toString(), x, y);
    }

    public void drawCells(int[] cells, int timeStep) {
    }

    public void draw() {
        JFrame jframe = new JFrame();
        jframe.add(this);
        jframe.setSize(640, 768);
        jframe.setLocation(0, 0);
        String name = "Experiment Visualization";
        if (this.index == 0) {
            jframe.setTitle(name);
        } else {
            jframe.setTitle(name + ": " + this.index);
        }
        jframe.setVisible(true);
    }
}

