/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import probabilisticcellularautomata.Tools;

public class OutputGraph
extends JPanel {
    private double[] sigmoidalXValues;
    private double[] xValues;
    private double[] averageRuntime;
    private double[] correct;
    private double[] incorrect;
    private double[] notTerminated;
    private int graphType;
    private int variable;
    private int index;
    private boolean drawFunction;

    public OutputGraph(double[] xValues, double[] correct, double[] incorrect, double[] notTerminated, double[] averageRuntime, int graphType, int variable, int index) {
        this.xValues = xValues;
        this.averageRuntime = averageRuntime;
        this.correct = correct;
        this.incorrect = incorrect;
        this.notTerminated = notTerminated;
        this.graphType = graphType;
        this.variable = variable;
        this.index = index;
        this.sigmoidalXValues = new double[xValues.length];
        for (int i = 0; i < xValues.length; ++i) {
            this.sigmoidalXValues[i] = xValues[i] / (1.0 - xValues[i]);
        }
        this.drawFunction = true;
    }

    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        int marginVertical = 50;
        int marginHorizontal = 50;
        int labelWidth = 20;
        int labelHeight = 10;
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        int boxWidth = windowWidth - 2 * marginHorizontal - labelWidth;
        int boxHeight = windowHeight - 2 * marginVertical - labelHeight;
        int linesX = windowWidth > 960 ? 21 : 11;
        int linesY = windowHeight > 561 ? 11 : 6;
        float linesXDistance = (float)boxWidth / (float)(linesX + 1);
        float linesYDistance = (float)boxHeight / (float)(linesY + 1);
        int lineLengthHorizontal = (int)(linesXDistance / 6.0f);
        int lineLengthVertical = (int)(linesYDistance / 6.0f);
        int dotHeight = 12 * windowHeight / 748;
        int dotWidth = 12 * windowWidth / 1280;
        double maxX = this.graphType == 0 || this.graphType == 1 ? OutputGraph.nextBound(OutputGraph.max(this.xValues)) : OutputGraph.nextBound(OutputGraph.max(this.sigmoidalXValues));
        double maxY = this.graphType == 0 || this.graphType == 2 ? OutputGraph.nextBound(OutputGraph.max(this.correct, this.incorrect, this.notTerminated)) : OutputGraph.nextBound(OutputGraph.max(this.averageRuntime));
        g2.setPaint(new Color(0, 0, 0));
        OutputGraph.drawThickRectangle(g2, marginHorizontal + labelWidth, marginVertical, boxWidth, boxHeight);
        g2.setPaint(new Color(255, 255, 255));
        g2.fillRect(marginHorizontal + labelWidth + 2, marginVertical + 2, boxWidth - 4, boxHeight - 4);
        g2.setPaint(new Color(0, 0, 0));
        for (i = 1; i <= linesY; ++i) {
            OutputGraph.drawThickHorizontalLine(g2, marginVertical + (int)((float)i * linesYDistance), marginHorizontal + labelWidth, marginHorizontal + labelWidth + lineLengthHorizontal);
            OutputGraph.drawThickHorizontalLine(g2, marginVertical + (int)((float)i * linesYDistance), marginHorizontal + labelWidth + boxWidth, marginHorizontal + labelWidth + boxWidth - lineLengthHorizontal);
        }
        g2.setPaint(new Color(0, 0, 0));
        for (i = 1; i <= linesX; ++i) {
            OutputGraph.drawThickVerticalLine(g2, marginHorizontal + labelWidth + (int)((float)i * linesXDistance), marginVertical, marginVertical + lineLengthVertical);
            OutputGraph.drawThickVerticalLine(g2, marginHorizontal + labelWidth + (int)((float)i * linesXDistance), marginVertical + boxHeight, marginVertical + boxHeight - lineLengthVertical);
        }
        g2.setPaint(new Color(0, 0, 0));
        for (i = 0; i < linesY; ++i) {
            if (this.graphType == 0 || this.graphType == 2) {
                this.writeInteger(g2, (double)i * maxY / (double)(linesY - 1), 2 * (marginHorizontal + labelWidth) / 3, (float)(marginVertical + boxHeight - linesY) - linesYDistance - (float)((int)((float)i * linesYDistance)) + 5.0f, maxY);
                continue;
            }
            this.writeNumber(g2, (double)i * maxY / (double)(linesY - 1), 2 * (marginHorizontal + labelWidth) / 3, (float)(marginVertical + boxHeight - linesY) - linesYDistance - (float)((int)((float)i * linesYDistance)) + 5.0f, maxY);
        }
        g2.setPaint(new Color(0, 0, 0));
        int temp = linesX / 10;
        for (int i2 = 0; i2 < 11; ++i2) {
            this.writeNumber(g2, (double)i2 * maxX / 10.0, (float)(marginHorizontal + labelWidth) + linesXDistance + (float)((int)((float)(i2 * temp) * linesXDistance)), marginVertical + boxHeight + (marginVertical + labelHeight) / 5, maxX);
        }
        g2.setPaint(new Color(0, 0, 0));
        if (this.graphType == 0 || this.graphType == 2) {
            this.writeText(g2, "Performance", marginHorizontal + labelWidth, marginVertical / 2);
        } else {
            this.writeText(g2, "Average time units", marginHorizontal + labelWidth, marginVertical / 2);
        }
        String sigmo = this.graphType == 2 || this.graphType == 3 ? "   (sigmoidal)" : "";
        if (this.variable == 2) {
            this.writeText(g2, "Density Threshold" + sigmo, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        } else if (this.variable == 5) {
            this.writeText(g2, "Maximum Runtime", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        } else if (this.variable == 6) {
            this.writeText(g2, "Lattice Size", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        } else if (this.variable == 7) {
            this.writeText(g2, "Density" + sigmo, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        } else if (this.variable == 8) {
            this.writeText(g2, "Degree of Chaos" + sigmo, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        } else {
            this.writeText(g2, "Success Probability" + sigmo, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        }
        for (int i3 = 0; i3 < this.xValues.length; ++i3) {
            double y;
            double x;
            if (!(this.correct[i3] + this.incorrect[i3] + this.notTerminated[i3] > 0.95)) continue;
            if (this.graphType == 0) {
                g2.setPaint(new Color(0, 0, 255));
                x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i3] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.notTerminated[i3];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
                g2.setPaint(new Color(255, 0, 0));
                x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i3] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.incorrect[i3];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
                g2.setPaint(new Color(0, 255, 0));
                x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i3] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.correct[i3];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
                continue;
            }
            g2.setPaint(new Color((int)Math.round(255.0 * this.incorrect[i3]), (int)Math.round(255.0 * this.correct[i3]), (int)Math.round(255.0 * this.notTerminated[i3])));
            x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i3] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
            y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.averageRuntime[i3];
            g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
        }
    }

    private static void drawThickRectangle(Graphics2D g2, int x, int y, int width, int height) {
        g2.drawRect(x - 1, y - 1, width + 2, height + 2);
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
    }

    private static void drawThickHorizontalLine(Graphics2D g2, int y, int x1, int x2) {
        g2.drawLine(x1, y - 1, x2, y - 1);
        g2.drawLine(x1, y, x2, y);
        g2.drawLine(x1, y + 1, x2, y + 1);
    }

    private static void drawThickVerticalLine(Graphics2D g2, int x, int y1, int y2) {
        g2.drawLine(x - 1, y1, x - 1, y2);
        g2.drawLine(x, y1, x, y2);
        g2.drawLine(x + 1, y1, x + 1, y2);
    }

    private static double max(double[] a) {
        double max = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
        }
        return max;
    }

    private static double max(double[] a, double[] b, double[] c) {
        return Math.max(OutputGraph.max(a), Math.max(OutputGraph.max(b), OutputGraph.max(c)));
    }

    public static double max(double a, double b, double c) {
        return Math.max(a, Math.max(b, c));
    }

    private static double nextBound(double d) {
        double result = Math.pow(10.0, Math.ceil(Math.log10(d)));
        if (result / 5.0 >= d) {
            result /= 5.0;
        } else if (result / 2.0 >= d) {
            result /= 2.0;
        }
        return result;
    }

    private void writeText(Graphics2D g2, String text, float x, float y) {
        Font font = g2.getFont();
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        float height = (float)font.getStringBounds(text, fontRenderContext).getHeight();
        float width = (float)font.getStringBounds(text, fontRenderContext).getWidth();
        g2.drawString(text, x - width / 2.0f, y + height / 2.0f);
    }

    private void writeNumber(Graphics2D g2, double d, float x, float y, double max) {
        if (max < 10.0) {
            this.writeText(g2, Tools.formatDouble(d, 1, 2), x, y);
        } else {
            this.writeText(g2, new Integer((int)Math.round(d)).toString(), x, y);
        }
    }

    private void writeInteger(Graphics2D g2, double d, float x, float y, double max) {
        if (max <= 1.0) {
            this.writeText(g2, Math.round(d * 100.0) + " %", x, y);
        } else {
            this.writeText(g2, new Integer((int)Math.round(d)).toString(), x, y);
        }
    }

    public void draw() {
        JFrame jframe = new JFrame();
        jframe.add(this);
        jframe.setSize(640, 768);
        jframe.setSize(640, 384);
        jframe.setTitle("Graph Visualization");
        if (this.graphType == 0) {
            jframe.setLocation(0, 0);
        } else if (this.graphType == 1) {
            jframe.setLocation(0, 384);
        } else if (this.graphType == 2) {
            jframe.setLocation(640, 0);
        } else {
            jframe.setLocation(640, 384);
        }
        jframe.setVisible(true);
    }
}

