/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class OutputProgressBar
extends JPanel {
    private int totalIterations;
    private int currentIteration = 0;
    private JFrame frame;

    public OutputProgressBar(int iterations) {
        this.totalIterations = iterations;
        this.frame = new JFrame();
    }

    public void setProgress(int currentIteration) {
        this.currentIteration = currentIteration < 0 ? 0 : (currentIteration > this.totalIterations ? this.totalIterations : currentIteration);
        this.update(this.getGraphics());
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        g2.setPaint(new Color(255, 255, 255));
        g2.fillRect(0, 0, windowWidth, windowHeight);
        int bars = windowWidth / 18;
        double spacesProportion = 0.2;
        double barWidth = (1.0 - spacesProportion) * ((double)windowWidth / ((double)bars + spacesProportion));
        double space = spacesProportion * ((double)windowWidth / ((double)bars + spacesProportion));
        g2.setPaint(new Color(0, 255, 0));
        for (int i = 1; i <= bars; ++i) {
            if (!((double)this.currentIteration / (double)this.totalIterations >= (double)i / (double)(bars + 1))) continue;
            g2.fillRect((int)(space + (double)(i - 1) * (barWidth + space)) + 1, (int)space + 1, (int)barWidth, (int)((double)windowHeight - 2.0 * space));
        }
    }

    public void delete(JFrame jframe) {
        jframe.remove(this);
    }

    public void close() {
        this.frame.dispose();
    }

    public void draw() {
        JFrame jframe = this.frame;
        jframe.add(this);
        jframe.setTitle("Progress");
        jframe.setSize(500, 80);
        jframe.setLocation(390, 334);
        jframe.setVisible(true);
        jframe.setAlwaysOnTop(true);
    }
}

