/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class OutputReport
extends JPanel {
    private String[] output = new String[0];
    private int task;
    private int index;

    public OutputReport(int task, int index) {
        this.task = task;
        this.index = index;
    }

    public String[] getOutput() {
        return this.output;
    }

    public void setOutput(String[] output) {
        this.output = output;
    }

    public void addLine(String s) {
        String[] result = new String[this.output.length + 1];
        for (int i = 0; i < this.output.length; ++i) {
            result[i] = this.output[i];
        }
        result[this.output.length] = s;
        this.output = result;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int marginVertical = 50;
        int marginHorizontal = 50;
        this.setFont(new Font("Courier", this.getFont().getStyle(), 10));
        int lineSpacing = 15;
        int labelHeight = 10;
        int textMarginVertical = 50;
        int textMarginHorizontal = 40;
        int textMarginHorizontal2 = 30;
        int textMarginHorizontal3 = 180;
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        int boxWidth = windowWidth - 2 * marginHorizontal;
        int boxHeight = windowHeight - 2 * marginVertical - labelHeight;
        g2.setPaint(new Color(255, 255, 255));
        OutputReport.drawThickRectangle(g2, marginHorizontal, marginVertical, boxWidth, boxHeight);
        g2.setPaint(new Color(255, 255, 255));
        g2.fillRect(marginHorizontal + 2, marginVertical + 2, boxWidth - 4, boxHeight - 4);
        int line = -1;
        for (int i = 0; i < this.output.length; ++i) {
            if (!this.output[i].isEmpty()) {
                if (this.output[i].charAt(0) == '$') {
                    this.drawCells(g2, this.output[i], windowWidth / 2 - (2 * (this.output[i].length() - 1) + 10) / 2, marginVertical + textMarginVertical + line * lineSpacing);
                } else if (this.output[i].charAt(0) == '\u25ba') {
                    g2.setPaint(new Color(0, 0, 0));
                    g2.drawString(this.output[i], marginHorizontal + textMarginHorizontal, marginVertical + textMarginVertical + ++line * lineSpacing - lineSpacing / 2);
                } else if (this.output[i].charAt(0) == '>') {
                    g2.setPaint(new Color(0, 0, 0));
                    g2.drawString(this.output[i], marginHorizontal + textMarginHorizontal + textMarginHorizontal2, marginVertical + textMarginVertical + line * lineSpacing);
                } else {
                    g2.setPaint(new Color(127, 127, 127));
                    g2.drawString(this.output[i], marginHorizontal + textMarginHorizontal + textMarginHorizontal2 + textMarginHorizontal3, marginVertical + textMarginVertical + --line * lineSpacing);
                }
            }
            ++line;
        }
    }

    public void drawCells(Graphics2D g2, String cells, int x, int y) {
        g2.setPaint(new Color(238, 238, 238));
        g2.fillRect(x, (y -= 6) - 4, 2 * cells.length() + 8, 12);
        for (int i = 1; i < cells.length(); ++i) {
            if (cells.charAt(i) == '0') {
                g2.setPaint(new Color(255, 255, 255));
                g2.fillRect(x - 1 + 4 + 2 * i, y + 1, 2, 2);
                continue;
            }
            g2.setPaint(new Color(0, 0, 0));
            g2.fillRect(x - 1 + 4 + 2 * i, y + 1, 2, 2);
        }
    }

    private static void drawThickRectangle(Graphics2D g2, int x, int y, int width, int height) {
        g2.setPaint(new Color(0, 0, 0));
        g2.drawRect(x - 1, y - 1, width + 2, height + 2);
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
    }

    public void draw() {
        JFrame jframe = new JFrame();
        jframe.add(this);
        jframe.setSize(640, 768);
        jframe.setLocation(640, 0);
        String name = this.task == 0 ? "Experiment Report" : (this.task == 1 ? "Statistic Report" : "Graph Report");
        if (this.index == 0) {
            jframe.setTitle(name);
        } else {
            jframe.setTitle(name + ": " + this.index);
        }
        jframe.setVisible(true);
    }
}

