/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class OutputStatistic
extends JPanel {
    private double correct;
    private double incorrect;
    private double notTerminated;
    private int index;

    public OutputStatistic(double correct, double incorrect, double notTerminated, int index) {
        this.correct = correct;
        this.incorrect = incorrect;
        this.notTerminated = notTerminated;
        this.index = index;
    }

    protected void paintComponent(Graphics g) {
        int i;
        int lineLengthVertical;
        Graphics2D g2 = (Graphics2D)g;
        int marginVertical = 50;
        int marginHorizontal = 50;
        int labelWidth = 20;
        int labelHeight = 10;
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        int boxWidth = windowWidth - 2 * marginHorizontal - labelWidth;
        int boxHeight = windowHeight - 2 * marginVertical - labelHeight;
        float lineXDistance = (float)boxWidth / 4.0f;
        float lineYDistance = (float)boxHeight / 12.0f;
        int lineLengthHorizontal = lineLengthVertical = (int)(lineYDistance / 6.0f);
        int barWidth = boxWidth / 7;
        g2.setPaint(new Color(0, 0, 0));
        OutputStatistic.drawThickRectangle(g2, marginHorizontal + labelWidth, marginVertical, boxWidth, boxHeight);
        g2.setPaint(new Color(255, 255, 255));
        g2.fillRect(marginHorizontal + labelWidth + 2, marginVertical + 2, boxWidth - 4, boxHeight - 4);
        g2.setPaint(new Color(0, 0, 0));
        for (i = 1; i <= 11; ++i) {
            OutputStatistic.drawThickHorizontalLine(g2, marginVertical + (int)((float)i * lineYDistance), marginHorizontal + labelWidth, marginHorizontal + labelWidth + lineLengthHorizontal);
            OutputStatistic.drawThickHorizontalLine(g2, marginVertical + (int)((float)i * lineYDistance), marginHorizontal + labelWidth + boxWidth, marginHorizontal + labelWidth + boxWidth - lineLengthHorizontal);
        }
        g2.setPaint(new Color(0, 0, 0));
        for (i = 1; i <= 3; ++i) {
            OutputStatistic.drawThickVerticalLine(g2, marginHorizontal + labelWidth + (int)((float)i * lineXDistance), marginVertical, marginVertical + lineLengthVertical);
            OutputStatistic.drawThickVerticalLine(g2, marginHorizontal + labelWidth + (int)((float)i * lineXDistance), marginVertical + boxHeight, marginVertical + boxHeight - lineLengthVertical);
        }
        g2.setPaint(new Color(0, 0, 0));
        for (i = 0; i < 11; ++i) {
            this.writeText(g2, new Integer(i * 10).toString() + " %", 2 * (marginHorizontal + labelWidth) / 3, (float)(marginVertical + boxHeight - 11) - lineYDistance - (float)((int)((float)i * lineYDistance)) + 10.0f);
        }
        this.writeText(g2, "Correct", (float)(marginHorizontal + labelWidth) + lineXDistance, marginVertical + boxHeight + (marginVertical + labelHeight) / 3);
        this.writeText(g2, "Incorrect", (float)(marginHorizontal + labelWidth) + lineXDistance + (float)((int)lineXDistance), marginVertical + boxHeight + (marginVertical + labelHeight) / 3);
        this.writeText(g2, "Not terminated", (float)(marginHorizontal + labelWidth) + lineXDistance + (float)((int)(2.0f * lineXDistance)), marginVertical + boxHeight + (marginVertical + labelHeight) / 3);
        g2.setPaint(new Color(0, 0, 0));
        g2.fillRect((int)((float)(marginHorizontal + labelWidth) + lineXDistance - (float)(barWidth / 2)) - 3, (int)((float)marginVertical + lineYDistance + (float)((int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * (1.0 - this.correct)))) - 3, barWidth + 6, (int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * this.correct) + 6);
        g2.setPaint(new Color(0, 255, 0));
        g2.fillRect((int)((float)(marginHorizontal + labelWidth) + lineXDistance - (float)(barWidth / 2)), (int)((float)marginVertical + lineYDistance + (float)((int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * (1.0 - this.correct)))), barWidth, (int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * this.correct));
        g2.setPaint(new Color(0, 0, 0));
        g2.fillRect((int)((float)(marginHorizontal + labelWidth) + 2.0f * lineXDistance - (float)(barWidth / 2)) - 3, (int)((float)marginVertical + lineYDistance + (float)((int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * (1.0 - this.incorrect)))) - 3, barWidth + 6, (int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * this.incorrect) + 6);
        g2.setPaint(new Color(255, 0, 0));
        g2.fillRect((int)((float)(marginHorizontal + labelWidth) + 2.0f * lineXDistance - (float)(barWidth / 2)), (int)((float)marginVertical + lineYDistance + (float)((int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * (1.0 - this.incorrect)))), barWidth, (int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * this.incorrect));
        g2.setPaint(new Color(0, 0, 0));
        g2.fillRect((int)((float)(marginHorizontal + labelWidth) + 3.0f * lineXDistance - (float)(barWidth / 2)) - 3, (int)((float)marginVertical + lineYDistance + (float)((int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * (1.0 - this.notTerminated)))) - 3, barWidth + 6, (int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * this.notTerminated) + 6);
        g2.setPaint(new Color(0, 0, 255));
        g2.fillRect((int)((float)(marginHorizontal + labelWidth) + 3.0f * lineXDistance - (float)(barWidth / 2)), (int)((float)marginVertical + lineYDistance + (float)((int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * (1.0 - this.notTerminated)))), barWidth, (int)Math.round((double)((float)boxHeight - 2.0f * lineYDistance) * this.notTerminated));
    }

    private void writeText(Graphics2D g2, String text, float x, float y) {
        Font font = g2.getFont();
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        float height = (float)font.getStringBounds(text, fontRenderContext).getHeight();
        float width = (float)font.getStringBounds(text, fontRenderContext).getWidth();
        g2.drawString(text, x - width / 2.0f, y + height / 3.0f);
    }

    private static void drawThickRectangle(Graphics2D g2, int x, int y, int width, int height) {
        g2.drawRect(x - 1, y - 1, width + 2, height + 2);
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
    }

    private static void drawThickHorizontalLine(Graphics2D g2, int y, int x1, int x2) {
        g2.drawLine(x1, y - 1, x2, y - 1);
        g2.drawLine(x1, y, x2, y);
        g2.drawLine(x1, y + 1, x2, y + 1);
    }

    private static void drawThickVerticalLine(Graphics2D g2, int x, int y1, int y2) {
        g2.drawLine(x - 1, y1, x - 1, y2);
        g2.drawLine(x, y1, x, y2);
        g2.drawLine(x + 1, y1, x + 1, y2);
    }

    public void draw() {
        JFrame jframe = new JFrame();
        jframe.add(this);
        jframe.setSize(640, 768);
        jframe.setLocation(0, 0);
        String name = "Statistic Visualization";
        if (this.index == 0) {
            jframe.setTitle(name);
        } else {
            jframe.setTitle(name + ": " + this.index);
        }
        jframe.setVisible(true);
    }
}

