/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Ellipse2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import probabilisticcellularautomata.Tools;

public class OutputStatisticManipulation
extends JPanel {
    private double[] originalAverageRuntime;
    private double[] originalCorrect;
    private double[] originalIncorrect;
    private double[] originalNotTerminated;
    private double[] xValues;
    private double[] averageRuntime;
    private double[] correct;
    private double[] incorrect;
    private double[] notTerminated;
    private int variable;
    private int graphType;
    private int manipulationType;
    private int manipulationAxes;

    public OutputStatisticManipulation(double[] xValues, double[] correct, double[] incorrect, double[] notTerminated, double[] averageRuntime, int variable, int graphType, int manipulationType, int manipulationAxes, int cutLeft, int cutRight) {
        int i;
        this.graphType = graphType;
        this.manipulationType = manipulationType;
        this.manipulationAxes = manipulationAxes;
        this.variable = variable;
        if (xValues == null) {
            xValues = new double[]{};
            averageRuntime = new double[]{};
            correct = new double[]{};
            incorrect = new double[]{};
            notTerminated = new double[]{};
        }
        if (cutLeft < 0) {
            cutLeft = 0;
        }
        if (cutRight < 0) {
            cutRight = 0;
        }
        if (cutLeft + cutRight <= xValues.length) {
            this.originalAverageRuntime = new double[xValues.length - cutLeft - cutRight];
            this.originalCorrect = new double[xValues.length - cutLeft - cutRight];
            this.originalIncorrect = new double[xValues.length - cutLeft - cutRight];
            this.originalNotTerminated = new double[xValues.length - cutLeft - cutRight];
            this.xValues = new double[xValues.length - cutLeft - cutRight];
            this.averageRuntime = new double[xValues.length - cutLeft - cutRight];
            this.correct = new double[xValues.length - cutLeft - cutRight];
            this.incorrect = new double[xValues.length - cutLeft - cutRight];
            this.notTerminated = new double[xValues.length - cutLeft - cutRight];
        } else {
            this.originalAverageRuntime = new double[0];
            this.originalCorrect = new double[0];
            this.originalIncorrect = new double[0];
            this.originalNotTerminated = new double[0];
            this.xValues = new double[0];
            this.averageRuntime = new double[0];
            this.correct = new double[0];
            this.incorrect = new double[0];
            this.notTerminated = new double[0];
        }
        for (i = 0; i < xValues.length; ++i) {
            if (xValues[0] < 1.0) {
                xValues[i] = xValues[i] * 100.0;
            }
            if (correct[0] < 1.0) {
                correct[i] = correct[i] * 100.0;
            }
            if (incorrect[0] < 1.0) {
                incorrect[i] = incorrect[i] * 100.0;
            }
            if (notTerminated[0] < 1.0) {
                notTerminated[i] = notTerminated[i] * 100.0;
            }
            if (!(averageRuntime[0] < 1.0)) continue;
            averageRuntime[i] = averageRuntime[i] * 100.0;
        }
        for (i = 0; i < this.xValues.length; ++i) {
            this.originalAverageRuntime[i] = averageRuntime[i + cutLeft];
            this.originalCorrect[i] = correct[i + cutLeft];
            this.originalIncorrect[i] = incorrect[i + cutLeft];
            this.originalNotTerminated[i] = notTerminated[i + cutLeft];
        }
        if (manipulationType == 0) {
            for (i = 0; i < this.xValues.length; ++i) {
                this.xValues[i] = this.manipulationAxes == 1 || this.manipulationAxes == 3 ? Math.pow(2.0, xValues[i + cutLeft]) : xValues[i + cutLeft];
                if (this.manipulationAxes == 2 || this.manipulationAxes == 3) {
                    this.averageRuntime[i] = Math.pow(2.0, averageRuntime[i + cutLeft]);
                    this.correct[i] = Math.pow(2.0, correct[i + cutLeft]);
                    this.incorrect[i] = Math.pow(2.0, incorrect[i + cutLeft]);
                    this.notTerminated[i] = Math.pow(2.0, notTerminated[i + cutLeft]);
                    continue;
                }
                this.averageRuntime[i] = averageRuntime[cutLeft];
                this.correct[i] = correct[i + cutLeft];
                this.incorrect[i] = incorrect[i + cutLeft];
                this.notTerminated[i] = notTerminated[i + cutLeft];
            }
        } else {
            for (i = 0; i < this.xValues.length; ++i) {
                this.xValues[i] = this.manipulationAxes == 1 || this.manipulationAxes == 3 ? Math.pow(xValues[i + cutLeft], 2.0) : xValues[i + cutLeft];
                if (this.manipulationAxes == 2 || this.manipulationAxes == 3) {
                    this.averageRuntime[i] = Math.pow(averageRuntime[i + cutLeft], 2.0);
                    this.correct[i] = Math.pow(correct[i + cutLeft], 2.0);
                    this.incorrect[i] = Math.pow(incorrect[i + cutLeft], 2.0);
                    this.notTerminated[i] = Math.pow(notTerminated[i + cutLeft], 2.0);
                    continue;
                }
                this.averageRuntime[i] = averageRuntime[i + cutLeft];
                this.correct[i] = correct[i + cutLeft];
                this.incorrect[i] = incorrect[i + cutLeft];
                this.notTerminated[i] = notTerminated[i + cutLeft];
            }
        }
    }

    protected void paintComponent(Graphics g) {
        int i;
        Graphics2D g2 = (Graphics2D)g;
        int marginVertical = 50;
        int marginHorizontal = 50;
        int labelWidth = 20;
        int labelHeight = 10;
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        int boxWidth = windowWidth - 2 * marginHorizontal - labelWidth;
        int boxHeight = windowHeight - 2 * marginVertical - labelHeight;
        int linesX = windowWidth > 960 ? 21 : 11;
        int linesY = windowHeight > 561 ? 11 : 6;
        float linesXDistance = (float)boxWidth / (float)(linesX + 1);
        float linesYDistance = (float)boxHeight / (float)(linesY + 1);
        int lineLengthHorizontal = (int)(linesXDistance / 6.0f);
        int lineLengthVertical = (int)(linesYDistance / 6.0f);
        int dotHeight = 12 * windowHeight / 748;
        int dotWidth = 12 * windowWidth / 1280;
        double maxX = OutputStatisticManipulation.nextBound(OutputStatisticManipulation.max(this.xValues));
        double maxY = this.graphType == 0 ? OutputStatisticManipulation.nextBound(OutputStatisticManipulation.max(this.correct, this.incorrect, this.notTerminated)) : OutputStatisticManipulation.nextBound(OutputStatisticManipulation.max(this.averageRuntime));
        OutputStatisticManipulation.drawThickRectangle(g2, marginHorizontal + labelWidth, marginVertical, boxWidth, boxHeight);
        for (i = 1; i <= linesY; ++i) {
            OutputStatisticManipulation.drawThickHorizontalLine(g2, marginVertical + (int)((float)i * linesYDistance), marginHorizontal + labelWidth, marginHorizontal + labelWidth + lineLengthHorizontal);
            OutputStatisticManipulation.drawThickHorizontalLine(g2, marginVertical + (int)((float)i * linesYDistance), marginHorizontal + labelWidth + boxWidth, marginHorizontal + labelWidth + boxWidth - lineLengthHorizontal);
        }
        for (i = 1; i <= linesX; ++i) {
            OutputStatisticManipulation.drawThickVerticalLine(g2, marginHorizontal + labelWidth + (int)((float)i * linesXDistance), marginVertical, marginVertical + lineLengthVertical);
            OutputStatisticManipulation.drawThickVerticalLine(g2, marginHorizontal + labelWidth + (int)((float)i * linesXDistance), marginVertical + boxHeight, marginVertical + boxHeight - lineLengthVertical);
        }
        String manipulation = this.manipulationType == 0 ? "- log" : "- sqrt";
        if (this.graphType == 0) {
            if (this.manipulationAxes == 2 || this.manipulationAxes == 3) {
                this.writeText(g2, "Goodness" + manipulation, marginHorizontal + labelWidth, marginVertical / 2);
            } else {
                this.writeText(g2, "Goodness - lin", marginHorizontal + labelWidth, marginVertical / 2);
            }
        } else if (this.manipulationAxes == 2 || this.manipulationAxes == 3) {
            this.writeText(g2, "Average Runtime" + manipulation, marginHorizontal + labelWidth, marginVertical / 2);
        } else {
            this.writeText(g2, "Average Runtime - lin", marginHorizontal + labelWidth, marginVertical / 2);
        }
        if (this.variable == 2) {
            if (this.manipulationAxes == 1 || this.manipulationAxes == 3) {
                this.writeText(g2, "Density Threshold" + manipulation, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            } else {
                this.writeText(g2, "Density Threshold - lin", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            }
        } else if (this.variable == 5) {
            if (this.manipulationAxes == 1 || this.manipulationAxes == 3) {
                this.writeText(g2, "Maximum Runtime" + manipulation, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            } else {
                this.writeText(g2, "Maximum Runtime - lin", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            }
        } else if (this.variable == 6) {
            if (this.manipulationAxes == 1 || this.manipulationAxes == 3) {
                this.writeText(g2, "Lattice Size" + manipulation, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            } else {
                this.writeText(g2, "Lattice Size - lin", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            }
        } else if (this.variable == 7) {
            if (this.manipulationAxes == 1 || this.manipulationAxes == 3) {
                this.writeText(g2, "Density" + manipulation, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            } else {
                this.writeText(g2, "Density - lin", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            }
        } else if (this.variable == 8) {
            if (this.manipulationAxes == 1 || this.manipulationAxes == 3) {
                this.writeText(g2, "Degree of Chaos" + manipulation, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            } else {
                this.writeText(g2, "Degree of Chaos - lin", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
            }
        } else if (this.manipulationAxes == 1 || this.manipulationAxes == 3) {
            this.writeText(g2, "Binomial Distribution Probability" + manipulation, marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        } else {
            this.writeText(g2, "Binomial Distribution Probability - lin", marginHorizontal + labelWidth + boxWidth / 2, marginVertical + boxHeight + 3 * (labelHeight + marginVertical) / 5);
        }
        if (this.graphType == 0) {
            for (int i2 = 0; i2 < this.xValues.length; ++i2) {
                g2.setPaint(new Color(0, 0, 255));
                double x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i2] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                double y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.notTerminated[i2];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
                g2.setPaint(new Color(255, 0, 0));
                x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i2] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.incorrect[i2];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
                g2.setPaint(new Color(0, 255, 0));
                x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i2] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.correct[i2];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
            }
        } else {
            for (int i3 = 0; i3 < this.xValues.length; ++i3) {
                System.out.println((int)Math.round(2.55 * this.originalIncorrect[i3]) + "   " + (int)Math.round(2.55 * this.originalCorrect[i3]) + "   " + (int)Math.round(2.55 * this.originalNotTerminated[i3]));
                g2.setPaint(new Color((int)Math.round(2.55 * this.originalIncorrect[i3]), (int)Math.round(2.55 * this.originalCorrect[i3]), (int)Math.round(2.55 * this.originalNotTerminated[i3])));
                double x = (double)((float)boxWidth - 2.0f * linesXDistance) / maxX * this.xValues[i3] + (double)marginHorizontal + (double)labelWidth + (double)linesXDistance;
                double y = (double)((float)(marginVertical + boxHeight) - linesYDistance) - (double)((float)boxHeight - 2.0f * linesYDistance) / maxY * this.averageRuntime[i3];
                g2.fill(new Ellipse2D.Double(x - (double)(dotHeight / 2), y - (double)(dotHeight / 2), dotWidth, dotHeight));
            }
        }
    }

    private static void drawThickRectangle(Graphics2D g2, int x, int y, int width, int height) {
        g2.drawRect(x - 1, y - 1, width + 2, height + 2);
        g2.drawRect(x, y, width, height);
        g2.drawRect(x + 1, y + 1, width - 2, height - 2);
        g2.setPaint(new Color(255, 255, 255));
        g2.fillRect(x + 2, y + 2, width - 4, height - 4);
        g2.setPaint(new Color(0, 0, 0));
    }

    private static void drawThickHorizontalLine(Graphics2D g2, int y, int x1, int x2) {
        g2.drawLine(x1, y - 1, x2, y - 1);
        g2.drawLine(x1, y, x2, y);
        g2.drawLine(x1, y + 1, x2, y + 1);
    }

    private static void drawThickVerticalLine(Graphics2D g2, int x, int y1, int y2) {
        g2.drawLine(x - 1, y1, x - 1, y2);
        g2.drawLine(x, y1, x, y2);
        g2.drawLine(x + 1, y1, x + 1, y2);
    }

    private static double max(double[] a) {
        double max = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
        }
        return max;
    }

    private static double max(double[] a, double[] b, double[] c) {
        return Math.max(OutputStatisticManipulation.max(a), Math.max(OutputStatisticManipulation.max(b), OutputStatisticManipulation.max(c)));
    }

    public static double max(double a, double b, double c) {
        return Math.max(a, Math.max(b, c));
    }

    private static double nextBound(double d) {
        double result = Math.pow(10.0, Math.ceil(Math.log10(d)));
        if (result / 5.0 >= d) {
            result /= 5.0;
        } else if (result / 2.0 >= d) {
            result /= 2.0;
        }
        return result;
    }

    private void writeText(Graphics2D g2, String text, float x, float y) {
        Font font = g2.getFont();
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        float height = (float)font.getStringBounds(text, fontRenderContext).getHeight();
        float width = (float)font.getStringBounds(text, fontRenderContext).getWidth();
        g2.drawString(text, x - width / 2.0f, y + height / 2.0f);
    }

    private void writeNumber(Graphics2D g2, double d, float x, float y, double max) {
        if (max < 10.0) {
            this.writeText(g2, Tools.formatDouble(d, 1, 2), x, y);
        } else {
            this.writeText(g2, new Integer((int)Math.round(d)).toString(), x, y);
        }
    }

    private void writeInteger(Graphics2D g2, double d, float x, float y, double max) {
        if (max <= 1.0) {
            this.writeText(g2, Math.round(d * 100.0) + " %", x, y);
        } else {
            this.writeText(g2, new Integer((int)Math.round(d)).toString(), x, y);
        }
    }

    public void draw() {
        JFrame jframe = new JFrame();
        jframe.add(this);
        jframe.setSize(640, 768);
        jframe.setSize(640, 384);
        jframe.setTitle("Statistic Visualization");
        if (this.graphType == 0) {
            jframe.setLocation(0, 0);
        } else {
            jframe.setLocation(0, 384);
        }
        jframe.setVisible(true);
    }
}

