/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.Configuration;
import probabilisticcellularautomata.OutputReport;
import probabilisticcellularautomata.Tools;

public class Problem {
    private int status = -1;
    private int problemType;
    private double densityThreshold;
    private int[] templateCells;
    private int maximumRuntime;

    public Problem(double densityThreshold, int[] templateCells, int maximumRuntime) {
        this.problemType = densityThreshold != -3.0 ? 0 : (templateCells[0] != -3 ? 2 : 1);
        this.densityThreshold = densityThreshold;
        this.templateCells = templateCells;
        this.maximumRuntime = maximumRuntime;
    }

    public double getDensityThreshold() {
        return this.densityThreshold;
    }

    public int[] gettemplateCells() {
        return this.templateCells;
    }

    public int getMaximumRuntime() {
        return this.maximumRuntime;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public void setDensityThreshold(double densityThreshold) {
        this.densityThreshold = densityThreshold;
    }

    public void settemplateCells(int[] templateCells) {
        this.templateCells = templateCells;
    }

    public void setMaxTime(int maximumRuntime) {
        this.maximumRuntime = maximumRuntime;
    }

    public void setProblemType(int problemType) {
        this.problemType = problemType;
    }

    public void initialize() {
        if (this.status == -1) {
            if (this.densityThreshold == -1.0) {
                this.densityThreshold = Math.random();
            }
            if (this.maximumRuntime == -1) {
                this.maximumRuntime = Tools.uniformRandomVariable(1, 1000);
            }
            this.status = 0;
        }
    }

    public int finished(Configuration startConfiguration, Configuration currentConfiguration, int currentTime) {
        if (this.problemType == 0) {
            if (currentConfiguration.getDensity() != 0.0 && currentConfiguration.getDensity() != 1.0 && currentTime != this.maximumRuntime + 1) {
                return 0;
            }
            if (currentConfiguration.getDensity() == 0.0 && startConfiguration.getDensity() < this.densityThreshold || currentConfiguration.getDensity() == 1.0 && startConfiguration.getDensity() >= this.densityThreshold) {
                return 1;
            }
            if (currentConfiguration.getDensity() == 1.0 && startConfiguration.getDensity() < this.densityThreshold || currentConfiguration.getDensity() == 0.0 && startConfiguration.getDensity() >= this.densityThreshold) {
                return 2;
            }
            return 3;
        }
        if (this.problemType == 1) {
            if (currentConfiguration.getDensity() != 0.0 && currentConfiguration.getDensity() != 1.0 && currentTime != this.maximumRuntime + 1) {
                return 0;
            }
            if (currentConfiguration.getDensity() == 0.0 || currentConfiguration.getDensity() == 1.0) {
                return 1;
            }
            return 3;
        }
        if (this.problemType == 2) {
            if (!Problem.equal(currentConfiguration.getCells(), this.templateCells) && currentTime != this.maximumRuntime + 1) {
                return 0;
            }
            if (Problem.equal(currentConfiguration.getCells(), this.templateCells)) {
                return 1;
            }
            return 3;
        }
        return 4;
    }

    private static boolean equal(int[] a, int[] b) {
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        if (a == null && b == null) {
            return true;
        }
        boolean result = true;
        for (int i = 0; i < a.length; ++i) {
            result &= a[i] == b[i];
        }
        return result;
    }

    public Problem clone() {
        if (this.status == -1) {
            return new Problem(this.densityThreshold, (int[])this.templateCells.clone(), this.maximumRuntime);
        }
        System.out.println("Problem could not be cloned properly because it was already initialized!");
        return null;
    }

    public void print(OutputReport output) {
        output.addLine("\u25ba  PROBLEM:");
        output.addLine("> Problem type:");
        if (this.problemType == 0) {
            output.addLine("Majority Problem");
        } else if (this.problemType == 1) {
            output.addLine("Synchronisation Problem");
        } else {
            output.addLine("User defined problem");
        }
        output.addLine("> Density Threshold:");
        if (this.densityThreshold == -1.0) {
            output.addLine("random");
        } else if (this.densityThreshold == -2.0) {
            output.addLine("variable");
        } else if (this.densityThreshold == -3.0) {
            output.addLine("-");
        } else {
            output.addLine(this.densityThreshold + "");
        }
        output.addLine("> Final configuration:");
        if (this.templateCells[0] == -3) {
            output.addLine("-");
        } else {
            output.addLine("$" + Tools.toCellsString(this.templateCells));
        }
        output.addLine("> Maximum time units:");
        if (this.maximumRuntime == -1) {
            output.addLine("random");
        } else if (this.maximumRuntime == -2) {
            output.addLine("variable");
        } else if (this.maximumRuntime == -3) {
            output.addLine("-");
        } else {
            output.addLine(this.maximumRuntime + "");
        }
    }
}

