/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.OutputReport;
import probabilisticcellularautomata.Tools;

public class Rule {
    private int status = -1;
    private int numberOfRuleInstances;
    private double binomialDistributionProbability;
    private int applyRuleInstancesUniformly;
    private int[] probabilities;
    private int[] randomVariableLookupArray;
    private int[] ruleNumbers;
    private int[][] ruleBits;

    public Rule(int numberOfRuleInstances, double binomialDistributionProbability, int applyRuleInstancesUniformly, int[] ruleNumbers, int[] probabilities) {
        this.probabilities = probabilities;
        this.randomVariableLookupArray = new int[100];
        this.ruleNumbers = ruleNumbers;
        this.applyRuleInstancesUniformly = applyRuleInstancesUniformly;
        this.binomialDistributionProbability = binomialDistributionProbability;
        this.numberOfRuleInstances = numberOfRuleInstances;
        if (ruleNumbers[0] >= 0) {
            this.ruleBits = new int[8][numberOfRuleInstances];
            for (int i = 0; i < numberOfRuleInstances; ++i) {
                int temp = ruleNumbers[i];
                for (int j = 0; j < 8; ++j) {
                    this.ruleBits[j][i] = temp % 2;
                    temp /= 2;
                }
            }
        } else {
            this.ruleBits = null;
        }
    }

    public void initialize() {
        if (this.status == -1) {
            int i;
            if (this.applyRuleInstancesUniformly == -1) {
                this.applyRuleInstancesUniformly = Tools.bernoulliRandomVariable(0.5);
            }
            if (this.probabilities == null) {
                this.probabilities = new int[this.numberOfRuleInstances];
                if (this.binomialDistributionProbability == -1.0) {
                    this.binomialDistributionProbability = Math.random();
                }
                Rule.setBinomialProbabilities(this.probabilities, this.binomialDistributionProbability);
            }
            int index = 0;
            for (i = 0; i < this.probabilities.length; ++i) {
                for (int j = index; j < index + this.probabilities[i]; ++j) {
                    this.randomVariableLookupArray[j] = i;
                }
                index += this.probabilities[i];
            }
            if (this.ruleNumbers[0] == -1) {
                if (this.ruleNumbers[1] == 0) {
                    this.ruleNumbers = new int[this.numberOfRuleInstances];
                    for (i = 0; i < this.numberOfRuleInstances; ++i) {
                        this.ruleNumbers[i] = Tools.uniformRandomVariable(64, 127) * 2;
                    }
                } else if (this.ruleNumbers[1] == 1) {
                    this.ruleNumbers = new int[this.numberOfRuleInstances];
                    for (i = 0; i < this.numberOfRuleInstances; ++i) {
                        this.ruleNumbers[i] = Tools.uniformRandomVariable(1, 64) * 2 - 1;
                    }
                } else {
                    this.ruleNumbers = new int[this.numberOfRuleInstances];
                    for (i = 0; i < this.numberOfRuleInstances; ++i) {
                        this.ruleNumbers[i] = Tools.uniformRandomVariable(0, 255);
                    }
                }
            }
            this.ruleBits = new int[8][this.numberOfRuleInstances];
            for (int i2 = 0; i2 < this.numberOfRuleInstances; ++i2) {
                int temp = this.ruleNumbers[i2];
                for (int j = 0; j < 8; ++j) {
                    this.ruleBits[j][i2] = temp % 2;
                    temp /= 2;
                }
            }
            this.status = 0;
        }
    }

    public static void setBinomialProbabilities(int[] probabilities, double p) {
        int i;
        int n = probabilities.length - 1;
        int[] result = new int[n + 1];
        int acc = 0;
        for (i = 0; i <= n; ++i) {
            result[i] = (int)Math.round((double)(100 * (Rule.factorial(n) / (Rule.factorial(i) * Rule.factorial(n - i)))) * Math.pow(p, i) * Math.pow(1.0 - p, n - i));
            acc += result[i];
        }
        result[(int)Math.round((double)((double)n * p))] = result[(int)Math.round((double)n * p)] + 100 - acc;
        for (i = 0; i <= n; ++i) {
            probabilities[i] = result[i];
        }
    }

    public static double[] binomialDistribution(int n, double p) {
        double[] result = new double[n + 1];
        for (int x = 0; x <= n; ++x) {
            result[x] = (double)(Rule.factorial(n) / (Rule.factorial(x) * Rule.factorial(n - x))) * Math.pow(p, x) * Math.pow(1.0 - p, n - x);
        }
        return result;
    }

    private static int factorial(int n) {
        if (n <= 0) {
            return 1;
        }
        return n * Rule.factorial(n - 1);
    }

    public int[] getProbabilities() {
        return this.probabilities;
    }

    public int[][] getRuleBits() {
        return this.ruleBits;
    }

    public int[] getRandomVariableLookupArray() {
        return this.randomVariableLookupArray;
    }

    public int[] getRuleNumbers() {
        return this.ruleNumbers;
    }

    public int getApplyRuleInstancesUniformly() {
        return this.applyRuleInstancesUniformly;
    }

    public void setProbabilities(int[] probabilities) {
        this.probabilities = probabilities;
    }

    public void setBinomialDistributionProbability(double binomialDistributionProbability) {
        this.binomialDistributionProbability = binomialDistributionProbability;
    }

    public void setNumberOfRuleInstances(int numberOfRuleInstances) {
        this.numberOfRuleInstances = numberOfRuleInstances;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public double getBinomialDistributionProbability() {
        return this.binomialDistributionProbability;
    }

    public int getNumberOfRuleInstances() {
        return this.numberOfRuleInstances;
    }

    public int getStatus() {
        return this.status;
    }

    public void setRuleBits(int[][] ruleBits) {
        this.ruleBits = ruleBits;
    }

    public void setRuleNumbers(int[] ruleNumbers) {
        this.ruleNumbers = ruleNumbers;
    }

    public void setApplyRuleInstancesUniformly(int applyRuleInstancesUniformly) {
        this.applyRuleInstancesUniformly = applyRuleInstancesUniformly;
    }

    public void print(OutputReport output) {
        output.addLine("\u25ba  RULE:");
        output.addLine("> Number of rules:");
        output.addLine(this.numberOfRuleInstances + "");
        output.addLine("> Success probability:");
        if (this.binomialDistributionProbability == -1.0) {
            output.addLine("random");
        } else if (this.binomialDistributionProbability == -2.0) {
            output.addLine("variable");
        } else if (this.binomialDistributionProbability == -3.0) {
            output.addLine("-");
        } else {
            output.addLine(this.binomialDistributionProbability + "");
        }
        output.addLine("> Uniform rule application:");
        if (this.applyRuleInstancesUniformly == -1) {
            output.addLine("random");
        } else if (this.applyRuleInstancesUniformly == 0) {
            output.addLine("no");
        } else {
            output.addLine("yes");
        }
        output.addLine("> Probabilities:");
        if (this.probabilities == null) {
            output.addLine("to be set");
        } else {
            output.addLine(Tools.toPercentArrayString(this.probabilities) + "");
        }
        output.addLine("> Rules:");
        if (this.ruleNumbers[0] == -1) {
            output.addLine("random");
        } else {
            output.addLine(Tools.toArrayString(this.ruleNumbers) + "");
        }
        String temp = "";
        if (this.ruleBits != null) {
            output.addLine("> Lookup table:");
            output.addLine("      111  110  101  100  011  010  001  000");
            for (int i = 0; i < this.ruleNumbers.length; ++i) {
                temp = i + ".      ";
                for (int j = 7; j >= 0; --j) {
                    temp = temp + this.ruleBits[j][i] + "      ";
                }
                output.addLine("");
                output.addLine(temp);
            }
        }
    }

    public Rule clone() {
        if (this.status == -1) {
            if (this.probabilities == null) {
                return new Rule(this.numberOfRuleInstances, this.binomialDistributionProbability, this.applyRuleInstancesUniformly, (int[])this.ruleNumbers.clone(), null);
            }
            return new Rule(this.numberOfRuleInstances, this.binomialDistributionProbability, this.applyRuleInstancesUniformly, (int[])this.ruleNumbers.clone(), (int[])this.probabilities.clone());
        }
        System.out.println("Rule could not be cloned properly because it was already initialized!");
        return null;
    }
}

