/*
 * Decompiled with CFR 0.152.
 */
package probabilisticcellularautomata;

import probabilisticcellularautomata.Experiment;
import probabilisticcellularautomata.OutputProgressBar;
import probabilisticcellularautomata.OutputReport;
import probabilisticcellularautomata.OutputStatistic;

public class Statistic {
    private Experiment experiment;
    private int numberOfExperimentIterations;
    private int status;
    private double correct;
    private double incorrect;
    private double notTerminated;
    private double strangeOccurrences;
    private double averageRuntime;

    public Statistic(Experiment e, int i) {
        this.experiment = e;
        this.numberOfExperimentIterations = i;
        this.status = 0;
        this.correct = 0.0;
        this.incorrect = 0.0;
        this.notTerminated = 0.0;
        this.averageRuntime = 0.0;
    }

    public void run(boolean showProgress, int verbose, int index) {
        this.status = 1;
        OutputProgressBar progress = null;
        if (showProgress) {
            progress = new OutputProgressBar(this.numberOfExperimentIterations);
            progress.draw();
        }
        int totalCorrect = 0;
        int totalIncorrect = 0;
        int totalNotTerminated = 0;
        int totalRuntime = 0;
        int totalStrangeOccurrences = 0;
        int[] results = new int[this.numberOfExperimentIterations];
        for (int i = 1; i <= this.numberOfExperimentIterations; ++i) {
            Experiment temp = this.experiment.clone();
            temp.run(false, verbose - 1, i);
            if (temp.getStatus() == 1) {
                ++totalCorrect;
                results[i - 1] = 1;
            } else if (temp.getStatus() == 2) {
                results[i - 1] = 2;
                ++totalIncorrect;
            } else if (temp.getStatus() == 3) {
                results[i - 1] = 3;
                ++totalNotTerminated;
            } else {
                results[i - 1] = 4;
                ++totalStrangeOccurrences;
            }
            if (showProgress) {
                progress.setProgress(i);
            }
            totalRuntime += temp.getDuration();
        }
        this.status = 2;
        this.correct = (double)totalCorrect / (double)this.numberOfExperimentIterations;
        this.incorrect = (double)totalIncorrect / (double)this.numberOfExperimentIterations;
        this.notTerminated = (double)totalNotTerminated / (double)this.numberOfExperimentIterations;
        this.strangeOccurrences = (double)totalStrangeOccurrences / (double)this.numberOfExperimentIterations;
        this.averageRuntime = (double)totalRuntime / (double)this.numberOfExperimentIterations;
        if (showProgress) {
            progress.close();
        }
        if (verbose > 0) {
            new OutputStatistic(this.correct, this.incorrect, this.notTerminated, index).draw();
            this.print(new OutputReport(1, index));
        }
    }

    public double getCorrect() {
        return this.correct;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public double getIncorrect() {
        return this.incorrect;
    }

    public double getNotTerminated() {
        return this.notTerminated;
    }

    public int getNumberOfExperimentIterations() {
        return this.numberOfExperimentIterations;
    }

    public double getAverageRuntime() {
        return this.averageRuntime;
    }

    public int getStatus() {
        return this.status;
    }

    public double getStrangeOccurrences() {
        return this.strangeOccurrences;
    }

    public void setCorrect(double correct) {
        this.correct = correct;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public void setIncorrect(double incorrect) {
        this.incorrect = incorrect;
    }

    public void setNotTerminated(double notTerminated) {
        this.notTerminated = notTerminated;
    }

    public void setNumberOfExperimentIterations(int numberOfExperimentIterations) {
        this.numberOfExperimentIterations = numberOfExperimentIterations;
    }

    public void setAvergareRuntime(double averageRuntime) {
        this.averageRuntime = averageRuntime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStrangeOccurrences(double strangeOccurrences) {
        this.strangeOccurrences = strangeOccurrences;
    }

    public Statistic clone() {
        return new Statistic(this.experiment.clone(), this.numberOfExperimentIterations);
    }

    public void print(OutputReport output) {
        output.addLine("\u25ba  STATISTIC:");
        output.addLine("> Number of Experiments:");
        output.addLine(this.numberOfExperimentIterations + "");
        if (this.status != 0) {
            output.addLine("> Correctly solved:");
            output.addLine(this.correct * 100.0 + " %");
            output.addLine("> Incorrectly solved:");
            output.addLine(this.incorrect * 100.0 + " %");
            output.addLine("> Not terminated:");
            output.addLine(this.notTerminated * 100.0 + " %");
            output.addLine("> Average running time:");
            output.addLine(this.averageRuntime + "");
        }
        this.experiment.print(output);
    }
}

